/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.common;

import com.ibm.hsc.cim.client.pi.PIHSCIOCIMClient;
import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PILPARProfileDataBean;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.GeneralUtil;
import com.ibm.hsc.common.util.HscUtilBase;
import com.ibm.hsc.websm.common.LparAttributes;
import com.ibm.hsc.websm.common.LparUtils;
import com.ibm.hsc.websm.common.ProfileAttributes;
import com.ibm.hsc.websm.common.WSMCommonUtil;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.mobject.MOXContainerObj;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class ProfileUtils {
    private static final String DONE = " ######## DONE ######## ";
    private static final String DB_STRING = "ProfileUtils>>>>> ";
    private static final String[] CEC_KEYS = new String[]{"name", "type_model", "serial_num", "max_lpars", "hyp_capabilities", "mem_region_size", "max_power_ctrl_lpars", "min_proc_units_per_virtual_proc", "max_shared_proc_pools", "max_vlans_per_port", "mac_prefix", "configurable_sys_mem", "configurable_sys_proc_units", "max_os400_proc_units", "assign_5250_cpw_percent", "max_io_pools", "sys_firmware_mem", "installed_sys_mem", "installed_sys_proc_units", "max_virtual_procs_per_lpar"};

    public static Vector getAllProfilesPropTables(String string, String[] stringArray, String string2) throws PIHscClientException {
        Object var3_3 = null;
        Vector vector = new Vector(0);
        String string3 = null;
        Object var6_6 = null;
        string3 = GeneralUtil.getCecIntName(string);
        if (IDebug.enabled) {
            System.err.println(" getAllProfilesPropTables: CEC ID " + string3);
        }
        PIHSCCECClient pIHSCCECClient = null;
        PIHSCClientObjectFactory pIHSCClientObjectFactory = null;
        try {
            pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string2, "root/ibmhscS1_0");
            pIHSCCECClient = pIHSCClientObjectFactory.createCECClient(string3, true);
            Vector vector2 = pIHSCCECClient.getLPARProfileDataBeans("%GET_ALL_PROF%", true, new Vector());
            if (vector2 == null) {
                if (IDebug.enabled) {
                    System.err.println("Returned profile vector is null");
                }
                return null;
            }
            if (IDebug.enabled) {
                System.err.println(" '" + vector2.size() + "' Vector size returned");
            }
            Iterator iterator = vector2.iterator();
            boolean bl = false;
            vector = LparUtils.getSquadronsProfileObjKeys(string3, string, string2);
            try {
                PILPARProfileDataBean pILPARProfileDataBean = null;
                Vector vector3 = new Vector();
                Vector vector4 = new Vector();
                Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
                Hashtable<String, Vector<String>> hashtable2 = new Hashtable<String, Vector<String>>();
                while (iterator.hasNext()) {
                    ProfileAttributes profileAttributes;
                    Hashtable hashtable3;
                    pILPARProfileDataBean = (PILPARProfileDataBean)iterator.next();
                    if (IDebug.enabled) {
                        System.err.println(" >>> Prof Name " + pILPARProfileDataBean.getName());
                        System.err.println(" >>> Prof int name " + pILPARProfileDataBean.getLparName());
                    }
                    if ((hashtable3 = (profileAttributes = new ProfileAttributes(pILPARProfileDataBean)).getBeanInfo(stringArray)) == null) continue;
                    String string4 = pILPARProfileDataBean.getLparId() + "~" + "IBMHSC_Partition" + "~";
                    String string5 = string4 + pILPARProfileDataBean.getSettingId() + "~";
                    if (IDebug.enabled) {
                        System.err.println("Key " + string5);
                    }
                    hashtable3.put("Name", string5);
                    hashtable3.put("nameSpace_Prop", "root/ibmhscS1_0");
                    hashtable.put(string5, hashtable3);
                    Vector<String> vector5 = (Vector<String>)hashtable2.get(string4);
                    if (vector5 == null) {
                        vector5 = new Vector<String>();
                    }
                    vector5.add(string5);
                    hashtable2.put(string4, vector5);
                }
                vector4.add(hashtable2);
                vector4.add(hashtable);
                return vector4;
            }
            catch (Throwable throwable) {
                if (IDebug.enabled) {
                    System.err.println("GOT Exception " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            System.err.println("ProfileUtils>>>>>  getAllProfilesPropTables()>>>>> : CIMException caught ....");
            exception.printStackTrace();
            exception.printStackTrace(System.out);
        }
        return new Vector();
    }

    public static Vector getPropTables(Vector vector, String[] stringArray, String string) throws PIHscClientException {
        ProfileAttributes profileAttributes = null;
        Hashtable hashtable = null;
        String string2 = null;
        Vector<Hashtable> vector2 = new Vector<Hashtable>(0);
        Iterator iterator = vector.iterator();
        try {
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                profileAttributes = new ProfileAttributes(string2, string);
                hashtable = profileAttributes.getAttributes(stringArray);
                vector2.add(hashtable);
            }
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                System.err.println("ProfileUtils>>>>>  getPropTables()>>>>> :Exception caught!!!!");
                pIHscClientException.printStackTrace();
            }
            throw pIHscClientException;
        }
        finally {
            return vector2;
        }
    }

    public static Hashtable getProfileParentsProperties(String string, String[] stringArray, String string2) throws PIHscClientException {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Vector vector = null;
        Hashtable hashtable = new Hashtable(0);
        vector = HscUtilBase.decodeKey(string);
        string5 = (String)vector.elementAt(0);
        string4 = string5.substring(0, string5.indexOf("*") + 1);
        string6 = string5 + "~" + (String)vector.elementAt(1) + "~";
        if (IDebug.enabled()) {
            System.err.println("ProfileUtils>>>>> getProfileParentsProperties>>>>>  lparId : " + string5 + " cecId: " + string4 + " lparKey : " + string6 + " profKey : " + string);
        }
        if ((string3 = WSMCommonUtil.getLparNameSpace(string6)) == null) {
            String[] stringArray2 = new String[]{string3};
            throw new PIHscClientException("1970", "PIHscClienBundle", "1970", stringArray2, null);
        }
        try {
            LparAttributes lparAttributes = new LparAttributes(string6, string3, string2);
            hashtable = lparAttributes.getAttributes(stringArray);
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                System.err.println("ProfileUtils>>>>> getParentOfProfile()>>>>>");
                pIHscClientException.printStackTrace();
            }
            throw pIHscClientException;
        }
        return hashtable;
    }

    public static PILPARProfileDataBean getDataBean(String string, String string2) throws PIHscClientException {
        PILPARProfileDataBean pILPARProfileDataBean = null;
        try {
            ProfileAttributes profileAttributes = null;
            Hashtable hashtable = null;
            profileAttributes = new ProfileAttributes(string, string2);
            hashtable = profileAttributes.getAttributes(null);
            pILPARProfileDataBean = profileAttributes.getDataBean();
            if (IDebug.enabled()) {
                System.err.println("ProfileUtils>>>>>  getDataBean()>>>>> : bean = " + pILPARProfileDataBean);
            }
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                System.err.println("ProfileUtils>>>>>  getDataBean()>>>>> :Exception caught!!!!");
                pIHscClientException.printStackTrace();
            }
            throw pIHscClientException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return pILPARProfileDataBean;
    }

    public static PICECDataBean getCecDataBean(String string, String string2) throws PIHscClientException {
        return ProfileUtils.getCecDataBean(string, CEC_KEYS, string2);
    }

    public static PICECDataBean getCecDataBean(String string, String[] stringArray, String string2) throws PIHscClientException {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Vector vector = null;
        PICECDataBean pICECDataBean = null;
        vector = HscUtilBase.decodeKey(string);
        string6 = (String)vector.elementAt(0);
        string4 = string6.substring(string6.indexOf("*") + 1);
        string5 = string6 + "~" + (String)vector.elementAt(1);
        if (IDebug.enabled()) {
            System.err.println("ProfileUtils>>>>> getProfileParentsProperties>>>>>  lparId : " + string6 + " cecId: " + string4 + " lparKey : " + string5 + " profKey : " + string);
        }
        if ((string3 = WSMCommonUtil.getLparNameSpace(string5)) == null) {
            String[] stringArray2 = new String[]{string3};
            throw new PIHscClientException("1970", "PIHscClienBundle", "1970", stringArray2, null);
        }
        try {
            PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string2, string3);
            PIHSCCECClient pIHSCCECClient = pIHSCClientObjectFactory.createCECClient(string4, true);
            if (pIHSCCECClient != null) {
                pICECDataBean = pIHSCCECClient.getCECDataBean(stringArray);
            }
            if (pICECDataBean == null && IDebug.enabled) {
                IDebug.println((String)"@@@@@@@ERROR: ProfileUtils->getCecDataBean(),the CECDataBean from CIM Client is null.");
            }
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                System.err.println("ProfileUtils>>>>> getCecDataBean()>>>>>");
                pIHscClientException.printStackTrace();
            }
            throw pIHscClientException;
        }
        return pICECDataBean;
    }

    public static MOXContainerObj getLPARMOXContainerObj(MOXContainerObj mOXContainerObj) {
        Vector vector = mOXContainerObj.getParents("parent_child");
        return (MOXContainerObj)vector.firstElement();
    }

    public static Hashtable getCecIoInfo(MOXContainerObj mOXContainerObj) throws PIHscClientException, Throwable {
        String string = mOXContainerObj.getKey();
        Vector vector = WSMCommonUtil.parseProfileKey(string);
        String string2 = (String)vector.elementAt(2);
        PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(mOXContainerObj.getHost().getName(), null);
        Hashtable hashtable = null;
        try {
            PIHSCIOCIMClient pIHSCIOCIMClient = pIHSCClientObjectFactory.createIOClient(string2, null, null, null, false);
            if (pIHSCIOCIMClient != null) {
                hashtable = pIHSCIOCIMClient.getIODrawerDataBeanHash(true);
            }
        }
        catch (PIHscClientException pIHscClientException) {
            pIHscClientException.printStackTrace();
            throw pIHscClientException;
        }
        return hashtable;
    }

    private static void debug(String string) {
        if (IDebug.enabled) {
            System.err.println("ProfileUtils: " + string);
        }
    }
}

